/* Thanks to Sandesh Karalkar for the original datepicker widget code */

function oeDatePicker()  {
 }
 
/**
*   Static variables
*/

/** The popup window containing the picker */
 oeDatePicker.gPopup  = null;
 
 
/** The original starting date and currently selected date */
 oeDatePicker.gOriginalDate = null; 
 oeDatePicker.gSelectedDate = null; 
 oeDatePicker.launchAdd = false;
 
 /* selected items */
 oeDatePicker.gSelectedMonthItem = null;
 oeDatePicker.gSelectedDayItem = null;
 
 oeDatePicker.gTodaysDate = new Date();
 
 oeDatePicker.gStartingDayOfWeek = 0; // 0 for Sunday, 1 for Monday, etc
 
 oeDatePicker.isDatePicker = false;
 
  oeDatePicker.isQuickAlarm = false;
  
  oeDatePicker.isShowCalendar = false;
 
/**
*   Set up the picker, called when the popup pops
*/
oeDatePicker.onpopupshowing = function( startDate, isDatePicker, isQuickAlarm, isShowCalendar) {
   oeDatePicker.gTodaysDate = new Date();
	if ( isDatePicker ) {
		oeDatePicker.isDatePicker = true;
	}
	
	if ( isQuickAlarm ) {
		oeDatePicker.isQuickAlarm = true;
	}
	else {
		oeDatePicker.isQuickAlarm = false;
	}
	
	if ( isShowCalendar ) {
		oeDatePicker.isShowCalendar = true;
	}
	else {
		oeDatePicker.isShowCalendar = false;
	}
	
	
	try {
		oeDatePicker.gStartingDayOfWeek = reminderFox_prefs.getIntPref(REMINDER_FOX_PREF + "." + REMINDER_FOX_CALENDAR_START_DAY);
	} catch(e) {
		oeDatePicker.gStartingDayOfWeek = REMINDER_FOX_CALENDAR_START_DAY_DEFAULT;
	}	
	
	// redraw dates if neccessary
	if ( oeDatePicker.gStartingDayOfWeek != 0 ) {
		for ( var i = 0; i < 7; i++ ) {
			var dayItem = document.getElementById( "calDay" + i  );
			var modifiedNumber = i + oeDatePicker.gStartingDayOfWeek;
			modifiedNumber = reminderFox_mod( modifiedNumber , 7);			
		     dayItem.setAttribute( "value", reminderFox_getBundle().getString("rf.options.day." + modifiedNumber + ".name.MMM"));
			// mark "Sunday" as Red
			var dayBox = document.getElementById( "oe-date-picker-month-day-" + (i+1) + "-header-box" );
			if ( modifiedNumber == 0 ) {
				dayBox.setAttribute( "class",  "oe-date-picker-month-days-header-class-red");
			}
			else {
				dayBox.setAttribute( "class",  "oe-date-picker-month-days-box-header-class");				
			}
		}
	}
	
   oeDatePicker.gOriginalDate = new Date( startDate );
   oeDatePicker.gSelectedDate = new Date( startDate );
   
   // draw the year based on the selected date   
   oeDatePicker.redrawYear();
   // draw the month based on the selected date   
   var month = oeDatePicker.gSelectedDate.getMonth() + 1;
   var selectedMonthBoxItem = document.getElementById( "oe-date-picker-year-month-" + month + "-box"  );
   oeDatePicker.selectMonthItem( selectedMonthBoxItem );
   
   // draw in the days for the selected date
   oeDatePicker.redrawDays();
}

 
oeDatePicker.gotoToday = function () {
	oeDatePicker.gSelectedDate = oeDatePicker.gTodaysDate;
	oeDatePicker.onpopupshowing(oeDatePicker.gSelectedDate,  oeDatePicker.isDatePicker,  oeDatePicker.isQuickAlarm, oeDatePicker.isShowCalendar);
	
	if ( !oeDatePicker.isDatePicker ) {
		// reset the reminder array, so all reminders will be re-added in case the year-change affects
		// them (like <1978> style reminders)
		calendarReminderArray = null;
		calendarTodoArray = null;
	}
	
   // update the selected date
   	if ( !oeDatePicker.isDatePicker ) {
   		var oldYear = oeDatePicker.gSelectedDate.getFullYear(); 
	   // redraw the year and the days
	   repopulateListForYear( oldYear , oeDatePicker.gSelectedDate.getFullYear() );
   	}
   
   oeDatePicker.redrawYear();
   oeDatePicker.redrawDays();
   
   	if ( !oeDatePicker.isDatePicker ) {
	   selectCalendarSync = false;
		highlightClosestUpcomingReminder( oeDatePicker.gSelectedDate  );    
		selectCalendarSync = true;
   	}
	
	if ( !oeDatePicker.isDatePicker ) {
		highlightReminderForDate( oeDatePicker.gSelectedDate.getMonth(), oeDatePicker.gSelectedDate.getDate()  );
	}
} 
 
/**
*   Called when a day is clicked, close the picker and call the client's oncommand
*/
oeDatePicker.clickDay = function( element, newDayItemNumber ) {
   // get the clicked day
   var dayNumberItem = document.getElementById( "oe-date-picker-month-day-text-" + newDayItemNumber );
   
   var dayNumber = dayNumberItem.getAttribute( "value" );
   
   // they may have clicked an unfilled day, if so ignore it and leave the picker up
   if (dayNumber == "") {
   	if (newDayItemNumber < 20) {
		// if this is at the start of the month....  see how far ahead of month start we are
		var found = false;
		for (var i = newDayItemNumber + 1; i < 43 && !found; i++) {
			var dayNumberItemLookAhead = document.getElementById("oe-date-picker-month-day-text-" + i);
			var dayNumberLookAhead = dayNumberItemLookAhead.getAttribute("value");
			if (dayNumberLookAhead != "") {
				// we found the first value
				var daysBefore = newDayItemNumber - i;
				// set the selected date to what they clicked on
				oeDatePicker.gSelectedDate.setDate(daysBefore+1);
				oeDatePicker.onpopupshowing(oeDatePicker.gSelectedDate,  oeDatePicker.isDatePicker,  oeDatePicker.isQuickAlarm, oeDatePicker.isShowCalendar);
				found = true;
				
				if ( !oeDatePicker.isDatePicker ) {
					highlightReminderForDate( oeDatePicker.gSelectedDate.getMonth(), oeDatePicker.gSelectedDate.getDate()  );
				}
				else {
					if ( oeDatePicker.isQuickAlarm || oeDatePicker.isShowCalendar ) {
						// do nothing
					}
					else {
						// we never want to close the window in this case
						//var popup = reminderFox_findParentById( element, "oe-date-picker-popup", "oe-date-picker-popup-end" );
						//popup.hidePopup();
					}
				}
				
			}
		}	   	
	}
	else {
		var found = false;
		for (var i = newDayItemNumber - 1; i >= 0 && !found; i--) {
			var dayNumberItemLookAhead = document.getElementById("oe-date-picker-month-day-text-" + i);
			var dayNumberLookAhead = dayNumberItemLookAhead.getAttribute("value");
			if (dayNumberLookAhead != "") {
				// we found the first value
				
				var daysAfter = newDayItemNumber - i;
				// set the selected date to what they clicked on
				
				// set date to first date; otherwise if it is Jan 29 for isntance, 
				// when we advance the month it will go to March (because Feb only has 28 days)
				oeDatePicker.gSelectedDate.setDate(1);  
				oeDatePicker.gSelectedDate.setMonth(oeDatePicker.gSelectedDate.getMonth() + 1);
				oeDatePicker.gSelectedDate.setDate(daysAfter);
				
				oeDatePicker.onpopupshowing(oeDatePicker.gSelectedDate,  oeDatePicker.isDatePicker,  oeDatePicker.isQuickAlarm, oeDatePicker.isShowCalendar);
				found = true;
				if ( !oeDatePicker.isDatePicker ) {
					highlightReminderForDate( oeDatePicker.gSelectedDate.getMonth(), oeDatePicker.gSelectedDate.getDate()  );
				}
				else {
					if ( oeDatePicker.isQuickAlarm || oeDatePicker.isShowCalendar ) {
						// do nothing
					}
					else {
						// we never want to close the window in this case
						//var popup = reminderFox_findParentById( element, "oe-date-picker-popup", "oe-date-picker-popup-end" );
						//popup.hidePopup();
					}
				}
				
			}
		}	
	 }
   }
   else if( dayNumber != "" )  {
         // set the selected date to what they clicked on
         oeDatePicker.gSelectedDate.setDate( dayNumber );
		 oeDatePicker.redrawDays();
		if ( !oeDatePicker.isDatePicker ) {
			highlightReminderForDate( oeDatePicker.gSelectedDate.getMonth(), oeDatePicker.gSelectedDate.getDate()  );
		}
		else {
			if ( oeDatePicker.isQuickAlarm  ) {
				// do nothing; the user must click the OK button in the quick alarm case to close
			}
			else {
				var popup = reminderFox_findParentById( element, "oe-date-picker-popup", "oe-date-picker-popup-end" );
				popup.hidePopup();
				if( oeDatePicker.launchAdd ) {
					oeDatePicker.launchAdd = false; 
					var reminderId =reminderFox_generateUniqueReminderId(  oeDatePicker.gSelectedDate );
					var newReminderToBeAdded = new ReminderFoxEvent( reminderId,  oeDatePicker.gSelectedDate, null );
					reminderFox_addReminderHeadlessly( newReminderToBeAdded );	
				}
			}
		}
   }
	
	var remindersTab = document.getElementById("remindersTab");
 	 if ( remindersTab != null  ) {   // ignore this if we are doing a popup from within the Event dialog
		var displayListIndex = getDisplayIndex();
		// week
		 if ( displayListIndex == 2 ) {
		 	if ( isReminderTabSelected() ) {			
				displayTypeChanged();
		 	}
		 	else {
		 		displayTypeChangedTodo();
		 	}
			oeDatePicker.redrawDays();	
			return;
		}
		// day
		if ( displayListIndex == 3 ) {
			if ( isReminderTabSelected() ) {			
				displayTypeChanged();
		 	}
		 	else {
		 		displayTypeChangedTodo();
		 	}
			oeDatePicker.redrawDays();	
			return;
		}			
 	 }		
}


/**
* Called when a month box is clicked 
*/

oeDatePicker.clickMonth = function( newMonthItem, newMonthNumber ){
   // already selected, return
   if( oeDatePicker.gSelectedMonthItem  == newMonthItem )   {
      return;
   }
   
   // Avoid problems when changing months if the date is at the end of the month
   // i.e. if date is 31 march and you do a setmonth to april, the month would
   // actually be set to may, beacause april only has 30 days.
   // This is why we keep the original date around.
   var oldDate = oeDatePicker.gSelectedDate.getDate();
   var yearNumber = oeDatePicker.gSelectedDate.getFullYear();
   
   var lastDayOfMonth = oeDatePicker.getLastDayOfMonth( yearNumber, newMonthNumber-1 );

   if ( oldDate > lastDayOfMonth )  {
       oeDatePicker.gSelectedDate.setDate(lastDayOfMonth);
   }
   
   // update the selected date   
   oeDatePicker.gSelectedDate.setMonth( newMonthNumber - 1 );
   
   // select Month   
   oeDatePicker.selectMonthItem( newMonthItem );
 
   // redraw days
   oeDatePicker.redrawDays();
 
	var remindersTab = document.getElementById("remindersTab");
 	 if ( remindersTab != null  ) {   // ignore this if we are doing a popup from within the Event dialog
		var displayListIndex = getDisplayIndex();

		// month
		if ( displayListIndex == 1 ) {
			if ( isReminderTabSelected() ) {			
				displayTypeChanged();
		 	}
		 	else {
		 		displayTypeChangedTodo();
		 	}
			oeDatePicker.redrawDays();				
		}
		// week
		else if ( displayListIndex == 2 ) {
			if ( isReminderTabSelected() ) {			
				displayTypeChanged();
		 	}
		 	else {
		 		displayTypeChangedTodo();
		 	}
		    oeDatePicker.redrawDays();
			return;
		}
		// day
		if ( displayListIndex == 3 ) {
			if ( isReminderTabSelected() ) {			
				displayTypeChanged();
		 	}
		 	else {
		 		displayTypeChangedTodo();
		 	}
			oeDatePicker.redrawDays();
			return;
		}	
 	 }
}
 
oeDatePicker.getLastDayOfMonth = function( year, month  ) {
   var pastLastDate = new Date( year, month, 32 );
   var lastDayOfMonth = 32 - pastLastDate.getDate();
   
   return lastDayOfMonth;
}

/**
* Called when previous Year button is clicked 
*/

oeDatePicker.previousYearCommand = function() {
	if ( !oeDatePicker.isDatePicker ) {
		// reset the reminder array, so all reminders will be re-added in case the year-change affects
		// them (like <1978> style reminders)
		calendarReminderArray = null;
		calendarTodoArray = null;
	}
	
   // update the selected date
   var oldDate = oeDatePicker.gSelectedDate.getDate();
   var oldYear = oeDatePicker.gSelectedDate.getFullYear(); 
   var lastDayOfMonth = oeDatePicker.getLastDayOfMonth( (oldYear - 1), oeDatePicker.gSelectedDate.getMonth() );
	
	// handle leap year scenario (Feb. 29 is selected and then the year is changed)
   if ( oldDate > lastDayOfMonth )
   {
       oeDatePicker.gSelectedDate.setDate(lastDayOfMonth);
   }

   oeDatePicker.gSelectedDate.setFullYear( oldYear - 1 ); 
   
   	if ( !oeDatePicker.isDatePicker ) {
    	repopulateListForYear( oldYear, oeDatePicker.gSelectedDate.getFullYear() );
   	}
   // redraw the year and the days   
   oeDatePicker.redrawYear();   
   oeDatePicker.redrawDays();

	if ( !oeDatePicker.isDatePicker ) {
	   	selectCalendarSync = false;
		highlightClosestUpcomingReminder( oeDatePicker.gSelectedDate  );   
		selectCalendarSync = true;
	}
}



oeDatePicker.previousMonthCommand = function() {
	if ( !oeDatePicker.isDatePicker ) {
		// reset the reminder array, so all reminders will be re-added in case the year-change affects
		// them (like <1978> style reminders)
		calendarReminderArray = null;
		calendarTodoArray = null;
	}
	
   // update the selected date
   var oldDate = oeDatePicker.gSelectedDate.getDate();
   var oldMonth = oeDatePicker.gSelectedDate.getMonth();
   var oldYear = oeDatePicker.gSelectedDate.getFullYear(); 
   var lastDayOfMonth = oeDatePicker.getLastDayOfMonth( oldYear, oeDatePicker.gSelectedDate.getMonth() - 1);
	
	// handle leap year scenario (Feb. 29 is selected and then the year is changed)
   if ( oldDate > lastDayOfMonth )
   {
       oeDatePicker.gSelectedDate.setDate(lastDayOfMonth);
   }

   oeDatePicker.gSelectedDate.setMonth( oldMonth - 1 ); 
   
   // draw the month based on the selected date   
   var month = oeDatePicker.gSelectedDate.getMonth() + 1;
   var selectedMonthBoxItem = document.getElementById( "oe-date-picker-year-month-" + month + "-box"  );
   oeDatePicker.selectMonthItem( selectedMonthBoxItem );
   
   
   	if ( !oeDatePicker.isDatePicker ) {
    	repopulateListForYear( oldYear, oeDatePicker.gSelectedDate.getFullYear() );
   	}
   // redraw the year and the days   
   oeDatePicker.redrawYear();   
   oeDatePicker.redrawDays();

	if ( !oeDatePicker.isDatePicker ) {
	   	selectCalendarSync = false;
		highlightClosestUpcomingReminder( oeDatePicker.gSelectedDate  );   
		selectCalendarSync = true;
	}
}


/**
* Called when next Year button is clicked 
*/

oeDatePicker.nextYearCommand = function() {
	if ( !oeDatePicker.isDatePicker ) {
		// reset the reminder array, so all reminders will be re-added in case the year-change affects
		// them (like <1978> style reminders)
		calendarReminderArray = null;
		calendarTodoArray = null;
	}
	
   // update the selected date
   var oldDate = oeDatePicker.gSelectedDate.getDate();
   var oldYear = oeDatePicker.gSelectedDate.getFullYear(); 
   var lastDayOfMonth = oeDatePicker.getLastDayOfMonth( (oldYear + 1), oeDatePicker.gSelectedDate.getMonth() );
	
	// handle leap year scenario (Feb. 29 is selected and then the year is changed)
   if ( oldDate > lastDayOfMonth )  {
       oeDatePicker.gSelectedDate.setDate(lastDayOfMonth);
   }   
   
   oeDatePicker.gSelectedDate.setFullYear( oldYear + 1 ); 
   
   	if ( !oeDatePicker.isDatePicker ) {
	   // redraw the year and the days
	   repopulateListForYear( oldYear , oeDatePicker.gSelectedDate.getFullYear() );
   	}
   
   oeDatePicker.redrawYear();
   oeDatePicker.redrawDays();
   
   	if ( !oeDatePicker.isDatePicker ) {
	   selectCalendarSync = false;
		highlightClosestUpcomingReminder( oeDatePicker.gSelectedDate  );    
		selectCalendarSync = true;
   	}
}

oeDatePicker.nextMonthCommand = function() {
	if ( !oeDatePicker.isDatePicker ) {
		// reset the reminder array, so all reminders will be re-added in case the year-change affects
		// them (like <1978> style reminders)
		calendarReminderArray = null;
		calendarTodoArray = null;
	}
	
   // update the selected date
   var oldDate = oeDatePicker.gSelectedDate.getDate();
   var oldYear = oeDatePicker.gSelectedDate.getFullYear(); 
   var oldMonth = oeDatePicker.gSelectedDate.getMonth(); 
   var lastDayOfMonth = oeDatePicker.getLastDayOfMonth( oldYear, oeDatePicker.gSelectedDate.getMonth() + 1 );
	
	// handle leap year scenario (Feb. 29 is selected and then the year is changed)
   if ( oldDate > lastDayOfMonth )  {
       oeDatePicker.gSelectedDate.setDate(lastDayOfMonth);
   }   
   
   oeDatePicker.gSelectedDate.setMonth( oldMonth + 1 ); 
   
   // draw the month based on the selected date   
   var month = oeDatePicker.gSelectedDate.getMonth() + 1;
   var selectedMonthBoxItem = document.getElementById( "oe-date-picker-year-month-" + month + "-box"  );
   oeDatePicker.selectMonthItem( selectedMonthBoxItem );
   
   	if ( !oeDatePicker.isDatePicker ) {
	   // redraw the year and the days
	   repopulateListForYear( oldYear , oeDatePicker.gSelectedDate.getFullYear() );
   	}
   
   oeDatePicker.redrawYear();
   oeDatePicker.redrawDays();
   
   	if ( !oeDatePicker.isDatePicker ) {
	   selectCalendarSync = false;
		highlightClosestUpcomingReminder( oeDatePicker.gSelectedDate  );    
		selectCalendarSync = true;
   	}
}

 

/**
* Draw the year based in the selected date 
*/

oeDatePicker.redrawYear = function(){
	var yearTitleItem = document.getElementById("oe-date-picker-year-title-text");
	yearTitleItem.setAttribute("value", oeDatePicker.gSelectedDate.getFullYear());
	
	
	var today = new Date();
	var month = today.getMonth() + 1;
	var selectedMonthBoxItem = document.getElementById( "oe-date-picker-year-month-" + month + "-box"  );
	if (today.getFullYear() == oeDatePicker.gSelectedDate.getFullYear()) {
		// embolden current month (just like today's date is emboldened)		
		selectedMonthBoxItem.setAttribute("today", true);
	}
	else {
		selectedMonthBoxItem.removeAttribute("today");
	}
}


oeDatePicker.resizeCalendar = function() {
  var calendarSize = 1;
  try {
		calendarSize = reminderFox_prefs.getIntPref(REMINDER_FOX_PREF + "." + REMINDER_FOX_CALENDAR_SIZE);
	} catch(e) {		
	}	

	if ( calendarSize > 1  ) {  // large 
		var datePicker =document.getElementById('oe-date-picker-overlay-box');
		datePicker.setAttribute( "large", "true");
		
		for ( var i = 1; i <= 42; i++ ) {
			var monthBox = "oe-date-picker-month-day-" + i + "-box";
			var monthBoxElement = document.getElementById(monthBox);
			monthBoxElement.setAttribute( "large", "large");
		}
		
		for ( var i = 1; i <= 6; i++ ) {
			var monthBox = "oe-date-picker-week-" + i + "-box";
			var monthBoxElement = document.getElementById(monthBox);
			monthBoxElement.setAttribute( "large", "true");
		}
	}
	else if ( calendarSize < 1 ) { // small 
		var datePicker =document.getElementById('oe-date-picker-overlay-box');
		datePicker.setAttribute( "small", "true");
		
		for ( var i = 1; i <= 42; i++ ) {
			var monthBox = "oe-date-picker-month-day-" + i + "-box";
			var monthBoxElement = document.getElementById(monthBox);
			monthBoxElement.setAttribute( "small", "true");
		}
		
		for ( var i = 1; i <= 6; i++ ) {
			var monthBox = "oe-date-picker-week-" + i + "-box";
			var monthBoxElement = document.getElementById(monthBox);
			monthBoxElement.setAttribute( "small", "true");
		}
	}
}

/**
* Select a month box 
*/

oeDatePicker.selectMonthItem = function( newMonthItem ) {
   // clear old selection, if there is one   
   
   if( oeDatePicker.gSelectedMonthItem != null )  { 
   		var id = oeDatePicker.gSelectedMonthItem.getAttribute( "id" ) ;
   		document.getElementById( id ).setAttribute( "selected" , false );  // set the poetenially cloned one as cleared
     	oeDatePicker.gSelectedMonthItem.setAttribute( "selected" , false );      
   }

   if ( newMonthItem != null ) { 
  		// Set the selected attribute, used to give it a different style   
    	newMonthItem.setAttribute( "selected" , true );
   }
      
   // Remember new selection  
  oeDatePicker.gSelectedMonthItem = newMonthItem;
}


/**
* Select a day box 
*/

oeDatePicker.selectDayItem = function( newDayItem ) {
   // clear old selection, if there is one   
   if( oeDatePicker.gSelectedDayItem != null )   {
   	  oeDatePicker.gSelectedDayItem.setAttribute( "selected" , false );
      oeDatePicker.gSelectedDayItem.setAttribute( "selectedReminder" , false );
   }

   if( newDayItem != null )   {
         // Set the selected attribute, used to give it a different style
   		var reminderDay =  newDayItem.getAttribute( "reminder" );
    	if ( reminderDay == "true" ) { 
    		newDayItem.setAttribute( "selectedReminder" , true );
    	}
    	else {
    	  newDayItem.setAttribute( "selected" , true );
    	  newDayItem.setAttribute( "selectedReminder" , false );
    	}
   }
         
   // Remember new selection      
   oeDatePicker.gSelectedDayItem = newDayItem;
}


/**
* Redraw day numbers based on the selected date
*/

oeDatePicker.redrawDays = function( ) {
	var dayNumberBoxItem;

   if ( oeDatePicker.gSelectedDate == null ) {
   	oeDatePicker.gSelectedDate = new Date();
   }
   // Write in all the day numbers
   var firstDate = new Date( oeDatePicker.gSelectedDate.getFullYear(), oeDatePicker.gSelectedDate.getMonth(), 1 );   
   var firstDayOfWeek = firstDate.getDay() - oeDatePicker.gStartingDayOfWeek;
   if ( firstDayOfWeek < 0 ) {
  	firstDayOfWeek =  firstDate.getDay() + (7 - oeDatePicker.gStartingDayOfWeek);
  }
  
   var lastDayOfMonth = oeDatePicker.getLastDayOfMonth( oeDatePicker.gSelectedDate.getFullYear(), oeDatePicker.gSelectedDate.getMonth() )
   var currentFirstDate = new Date( oeDatePicker.gTodaysDate.getFullYear(), oeDatePicker.gTodaysDate.getMonth(), 1 );
   var firstDayOfCurrentDateWeek = currentFirstDate.getDay()  - oeDatePicker.gStartingDayOfWeek;
   if ( firstDayOfCurrentDateWeek < 0 ) {
  	firstDayOfCurrentDateWeek =  currentFirstDate.getDay() + (7 - oeDatePicker.gStartingDayOfWeek);
  }

   // clear the selected day item   
   oeDatePicker.selectDayItem( null ); 
  
   var monthArray = null;   
   var isReminder = true;
   var remindersTab = document.getElementById("remindersTab");
   var lastMonthArray = null;
   if ( remindersTab != null  ) {   // ignore this if we are doing a popup from within the Event dialog
		if ( isReminderTabSelected() ) {			
		   if ( calendarReminderArray == null ) {	   		
		   		createCalendarReminderArray();	   				   		
		   	}
		   	monthArray = calendarReminderArray[oeDatePicker.gSelectedDate.getMonth()];
		   	if ( oeDatePicker.gSelectedDate.getMonth() > 0 ) {
		   		lastMonthArray = calendarReminderArray[oeDatePicker.gSelectedDate.getMonth()-1];
		   	}
		}
		else {
			isReminder = false;
		   	if ( calendarTodoArray == null ) {
		   		createCalendarTodoArray();
		   	}
		   	 monthArray = calendarTodoArray[oeDatePicker.gSelectedDate.getMonth()];
		   	 if ( oeDatePicker.gSelectedDate.getMonth() > 0 ) {
		   		lastMonthArray = calendarTodoArray[oeDatePicker.gSelectedDate.getMonth()-1];
		   	}
		}
   }
   else { 
     if ( oeDatePicker.launchAdd ) {
	   var calendarReminderArray2 = null;
	   if ( calendarReminderArray2 == null ) {	   		
			calendarReminderArray2 = createCalendarReminderArray2();	   				   		
		}
		monthArray = calendarReminderArray2[oeDatePicker.gSelectedDate.getMonth()];
		if ( oeDatePicker.gSelectedDate.getMonth() > 0 ) {
			lastMonthArray = calendarReminderArray2[oeDatePicker.gSelectedDate.getMonth()-1];
		}
	  }
	}
   
    var startOfThisMonthDate = new Date(oeDatePicker.gSelectedDate.getFullYear(), oeDatePicker.gSelectedDate.getMonth(), 0);
	var multipleDayEvents = new Array();
	var lastMonthReminders = new Array();
	// for performance; we just check last 10 days of previous month
	 if ( lastMonthArray != null && lastMonthArray.length > 0) {
	 	for ( var i = (lastMonthArray.length-10); i < lastMonthArray.length; i++ ) {
	 		var reminderDaysArray = lastMonthArray[i];
	 		if ( reminderDaysArray != null ) { 
   		 		for ( var j = 0; j < reminderDaysArray.length; j++ ) {
   		 			var reminder = reminderDaysArray[j];
   		 		 	reminderFox_addMultipleEndDates( reminder, startOfThisMonthDate, lastMonthReminders );
   		 		}	
	 		}
	 	}
	 	
	 	// now convert to this multipleenddate
	 	for ( var i = 0; i < lastMonthReminders.length; i++ ) {
	 		var lastMonthReminder = lastMonthReminders[i];
	 		var important = 	lastMonthReminder.priority == REMINDER_PRIORITY_IMPORTANT;
	 		var completed = false;
	 		if ( lastMonthReminder.completedDate != null )  {
				if ( isReminder ) {
					var calendarDate = new Date(oeDatePicker.gSelectedDate.getFullYear(),oeDatePicker.gSelectedDate.getMonth(), lastMonthReminder.date.getDate() );
					// continue if marked complete
					if ( reminderFox_isCompletedForDate(lastMonthReminder, calendarDate ) ) {					
						completed = true;							
					}
				}
				else {
					completed = true; // todo's should be shown as completed regardless of their date (as they have no multiple date occurrences)
				}
			}
	 		
	 		
			if ( lastMonthReminder.allDayEvent ) {
				if (lastMonthReminder.durationTime >86400000 ) {   // 24 * 60 * 60 * 1000 = 1 day in ms
					//var reminderInstanceDate = new Date(oeDatePicker.gSelectedDate.getFullYear(),oeDatePicker.gSelectedDate.getMonth(), dayNumber );
					var reminderInstanceDate =lastMonthReminder.date;
					var reminderInstanceEndDate = new Date(reminderInstanceDate.getTime() + lastMonthReminder.durationTime);		
					reminderInstanceEndDate.setDate( reminderInstanceEndDate.getDate() - 1); // -1 enddate offset
					// set end date
					multipleDayEvents[multipleDayEvents.length] = { description: lastMonthReminder.summary, isCompleted:  completed,  isImportant: important, endDate: reminderInstanceEndDate };
				}
			}
			else {
				if ( lastMonthReminder.durationTime > 60000 ) {
					var reminderInstanceDate =lastMonthReminder.date;
					var reminderInstanceEndDate = new Date(reminderInstanceDate.getTime() + lastMonthReminder.durationTime);	
					
					if (reminderInstanceEndDate.getMonth() == reminderInstanceDate.getMonth() &&
						reminderInstanceEndDate.getDate() == reminderInstanceDate.getDate() ) {
						// same days..  do nothing
					}
					// multiple days
					else { 
						// set end date
						multipleDayEvents[multipleDayEvents.length] = { description: lastMonthReminder.summary, isCompleted:  completed,  isImportant: important, endDate: reminderInstanceEndDate };
					}
				}
			}
	 	
	 	}
	 }
	
   // redraw each day box in the 7 x 6 grid 
   var dayNumber = 1;
   //	var multipleDayEvents = new Array();
   for( var dayIndex = 0; dayIndex < 42; ++dayIndex )  {
        // get the day text box
      	var dayNumberItem = document.getElementById( "oe-date-picker-month-day-text-" + (dayIndex + 1) );
        dayNumberBoxItem = document.getElementById( "oe-date-picker-month-day-" + (dayIndex + 1) + "-box" );
        
		// clear old styles and tooltips
        dayNumberBoxItem.setAttribute( "reminder" , false );
        dayNumberBoxItem.setAttribute( "completedReminder" , false );        
        dayNumberBoxItem.setAttribute( "important" , false );
        dayNumberBoxItem.setAttribute("tooltip", "");
		
		// embolden today's date
		if ( (oeDatePicker.gTodaysDate.getDate() + firstDayOfCurrentDateWeek) == (dayIndex + 1)
			&& oeDatePicker.gTodaysDate.getMonth() == oeDatePicker.gSelectedDate.getMonth()  && 
   			oeDatePicker.gTodaysDate.getYear() == oeDatePicker.gSelectedDate.getYear() ) {
		
	   		if ( dayNumberBoxItem.getAttribute("small") ) {
		   		dayNumberBoxItem.setAttribute( "smalltoday" , true );
	   		}
	   		else if ( dayNumberBoxItem.getAttribute("large") ) {
		   		dayNumberBoxItem.setAttribute( "largetoday" , true );
	   		}
	   		else {
	   			dayNumberBoxItem.setAttribute( "today" , true ); 
	   		}			
	  	}
		// clear other dates
	  	else {
	   	    if ( dayNumberBoxItem.getAttribute("medium") ) {       		 	   	
	   			dayNumberBoxItem.removeAttribute( "smalltoday");
	   	    }
	   	    else if ( dayNumberBoxItem.getAttribute("large") ) {       		 	   	
	   			dayNumberBoxItem.removeAttribute( "largetoday");
	   	    }
	   	    else {
	   			dayNumberBoxItem.removeAttribute( "today");
	   	    }
	   	}
		
		
		
		
        
      // if it is an unfilled day ( before first or after last ), just set its value to "",
   	  // and don't increment the day number.       
      if( dayIndex < firstDayOfWeek || dayNumber > lastDayOfMonth )  {
         dayNumberItem.setAttribute( "value" , "" );                
      }
      else {
		var important = false;
         // set the value to the day number         
         dayNumberItem.setAttribute( "value" , dayNumber );         
	
         if ( monthArray != null ) {
         	var reminderDaysArray = monthArray[dayNumber-1];
	 		 
	 		 // clear old tooltip
//	 	   	 var tooltipItem = document.getElementById( "day-"+dayNumber  +"-tooltip");
//		     while (tooltipItem.hasChildNodes()) {
//		    	 tooltipItem.removeChild(tooltipItem.firstChild);
//		  	 }
          	if ( reminderDaysArray != null ) {
				var reminderAdded = false;
				var completedReminderAdded = false;
				
         	   	for ( var  i = 0; i < reminderDaysArray.length; i++ ) {
					var 	reminder = reminderDaysArray[i];
					var completed = false;
					// don't add reminder to calendar widget if the event has been completed already
					if ( reminder.completedDate != null )  {
						if ( isReminder ) {
							var calendarDate = new Date(oeDatePicker.gSelectedDate.getFullYear(),oeDatePicker.gSelectedDate.getMonth(), dayNumber );
							// continue if marked complete
							if ( reminderFox_isCompletedForDate(reminder, calendarDate ) ) {					
								completed = true;							
							}
						}
						else {
							completed = true; // todo's should be shown as completed regardless of their date (as they have no multiple date occurrences)
						}
					}
	         		important = 	reminder.priority == REMINDER_PRIORITY_IMPORTANT;
	         		if ( important && !completed) {
	         		   	dayNumberBoxItem.setAttribute( "important" , true );
	         		 }	         		         

					if ( completed ) {
						completedReminderAdded = true;
					}
					else {
						reminderAdded = true;
					}
					
					// check end dates
					var endDateAdded = false;										
					
					if ( reminder.durationTime != null ) {
						if ( reminder.allDayEvent ) {
							if (reminder.durationTime >86400000 ) {   // 24 * 60 * 60 * 1000 = 1 day in ms
								//var reminderInstanceDate = new Date(oeDatePicker.gSelectedDate.getFullYear(),oeDatePicker.gSelectedDate.getMonth(), dayNumber );
								var reminderInstanceDate =reminder.date;
								var reminderInstanceEndDate = new Date(reminderInstanceDate.getTime() + reminder.durationTime);		
								reminderInstanceEndDate.setDate( reminderInstanceEndDate.getDate() - 1); // -1 enddate offset
								// set end date
								multipleDayEvents[multipleDayEvents.length] = { description: reminder.summary, isCompleted:  completed,  isImportant: important, endDate: reminderInstanceEndDate };
								endDateAdded = true;
							}
						}
						else {
							if ( reminder.durationTime > 60000 ) {
								var reminderInstanceDate =reminder.date;
								var reminderInstanceEndDate = new Date(reminderInstanceDate.getTime() + reminder.durationTime);	
								
								if (reminderInstanceEndDate.getMonth() == reminderInstanceDate.getMonth() &&
									reminderInstanceEndDate.getDate() == reminderInstanceDate.getDate() ) {
									// same days..  do nothing
								}
								// multiple days
								else { 
									// set end date
									multipleDayEvents[multipleDayEvents.length] = { description: reminder.summary, isCompleted:  completed,  isImportant: important, endDate: reminderInstanceEndDate };
									endDateAdded =true;
								}
							}
						}
					}					
     		    }
     		
     			if ( reminderAdded ) {
	     		   dayNumberBoxItem.setAttribute( "reminder" , true );
		           dayNumberBoxItem.setAttribute("tooltip", "day-"+dayNumber +"-tooltip");
     			}
     			else if ( completedReminderAdded ) {
     				dayNumberBoxItem.setAttribute( "completedReminder" , true );
		          	dayNumberBoxItem.setAttribute("tooltip", "day-"+dayNumber +"-tooltip");
     			}
	        }
	        

	        
         }
		 
		 
         
 	   // check the previous month for end dates carrying over past today
	    if ( multipleDayEvents.length > 0 ) { 	 
	    	var calendarDate = new Date(oeDatePicker.gSelectedDate.getFullYear(),oeDatePicker.gSelectedDate.getMonth(), dayNumber );
 		    for ( var e = 0; e < multipleDayEvents.length; e++ ) {
 		    	if ( calendarDate.getMonth() < multipleDayEvents[e].endDate.getMonth() || 
 		    		(calendarDate.getMonth() == multipleDayEvents[e].endDate.getMonth() && 
 		    			calendarDate.getDate() <= multipleDayEvents[e].endDate.getDate()) ) {
		         		if ( multipleDayEvents[e].isImportant  && !multipleDayEvents[e].isCompleted ) {
		         		   	dayNumberBoxItem.setAttribute( "important" , true );
		         		 }	         	

						if (  multipleDayEvents[e].isCompleted ) {
							dayNumberBoxItem.setAttribute( "completedReminder" , true );
				          	dayNumberBoxItem.setAttribute("tooltip", "day-"+dayNumber +"-tooltip");
						}
						else {
							dayNumberBoxItem.setAttribute( "reminder" , true );
				           dayNumberBoxItem.setAttribute("tooltip", "day-"+dayNumber +"-tooltip");
						}
 		    	}
 		    }
	    }
         
         // draw the day as selected
         if( dayNumber == oeDatePicker.gSelectedDate.getDate() ) 
         {
            dayNumberBoxItem = document.getElementById( "oe-date-picker-month-day-" + (dayIndex + 1) + "-box"  );
            oeDatePicker.selectDayItem( dayNumberBoxItem );
         }
         
         // advance the day number         
         ++dayNumber;  
      }
   }
   
   redrawWeekNumbers();
   
   	var multipleDayEvents = null;
 }
 
 
 function getStartAndEndDates2(displayListIndex, useToday) {
	var year;
	var month;
	var day;
	if ( oeDatePicker.gSelectedDate != null ) {
		year = oeDatePicker.gSelectedDate.getFullYear();
		month = oeDatePicker.gSelectedDate.getMonth();
		day = oeDatePicker.gSelectedDate.getDate();
	}
	if ( year == null ) {
		year = new Date().getFullYear();
		month = new Date().getMonth();
		day = new Date().getDate();
		
	}	 
	
	var startAndEnd = { start: null, end: null };  

		startAndEnd.start = new Date( year, 0, 1 );  // start of year
		startAndEnd.end  = new Date( year, 11, 31 );  // end of year
	
	return startAndEnd;
}
 
function createCalendarReminderArray2() {
	var monthArray;
	var monthDay;	
	var dayReminderArray;	
	var newDayReminder;
	var  length;
	var val;
		
	var calendarReminderArray2 = new Array(12); 
	var reminders = reminderFox_getReminderEvents();	
	
	var currentDate = oeDatePicker.gSelectedDate;
	if ( currentDate == null ) {
		currentDate = new Date();
	}
	var	year = currentDate.getFullYear();
	var dateSpan = getStartAndEndDates2();
	var todaysDate = new Date();
	for( var i = 0; i < reminders.length; i++) {
		var basereminder = reminders[i];
		
		var allReminders = reminderFox_getAllRemindersInDateRange( basereminder,  dateSpan.start, dateSpan.end, false );
		var x;
		// maybe make this a method that returns start/endindex
		var startIndex = 0;
		var endIndex = 0;
		if ( allReminders.length > 0 ) {
			endIndex  = allReminders.length;
		}
		if ( allReminders.length > 0) {
//			if ( SHOW_ALL_REMINDERS ) {
				startIndex = 0;
				endIndex = allReminders.length;
//			}
//			else if ( HIDE_ALL_REMINDERS ) {
//				for ( x = 0; x < allReminders.length; x++ ) {
//					if ( reminderFox_compareDates( allReminders[x].date, todaysDate) != -1 ) {
//						break;
//					}
//				}
//				// handle end case where x = length
//				startIndex = x;
//		
//				// need to show reminders of yearly that have passed
//				if ( startIndex == allReminders.length ) {				
//					startIndex = allReminders.length -1;
//				}
//				endIndex = startIndex + 1;  
//				if ( endIndex > allReminders.length )  {
//					endIndex = allReminders.length;
//				}
//			}
			// if there's only 1 reminder and the prefs are set to show prev/next, then just ignore the check
//			else if ( !(allReminders.length == 1 && REPEAT_PREVIOUS_OCCURRENCES >= 1 &&  REPEAT_UPCOMING_OCCURRENCES >=1 ) )  {			
//				for ( x = 0; x < allReminders.length; x++ ) {
//					if ( reminderFox_compareDates( allReminders[x].date, todaysDate) != -1 ) {
//						break;
//					}
//				}
//				
//				if ( REPEAT_PREVIOUS_OCCURRENCES == -1 ) { 
//					startIndex = 0;
//				}
//				else {
//					startIndex = x - REPEAT_PREVIOUS_OCCURRENCES;
//					if ( startIndex < 0 ) {
//						startIndex = 0;
//					}
//				}
//				
//				if ( REPEAT_UPCOMING_OCCURRENCES == -1 ) {
//					endIndex = allReminders.length;
//				}
//				else {
//					endIndex = x + REPEAT_UPCOMING_OCCURRENCES;
//					if ( endIndex > allReminders.length ) {
//						endIndex = allReminders.length;
//					}
//				}
//				
//				// if the user is showing no previous occurrences, we still want to show if a previous reminder is marked as RUC
//				if ( REPEAT_PREVIOUS_OCCURRENCES == 0 && 
//					basereminder.remindUntilCompleted == REMINDERFOX_REMIND_UNTIL_COMPLETE_MARKED ) {
//					if ( startIndex > 0  && startIndex == endIndex  ) { // eminderFox_compareDates( allReminders[x].date, todaysDate) == 1 ) {
//						startIndex = startIndex - 1;														
//					}					
//				}								
//			 }
		}
       for (  var j = startIndex; j < endIndex; j++ ) {		
			var reminder = allReminders[j];		
			reminder = reminderFox_processReminderDescription(reminder,  dateSpan.start.getFullYear(), false);	
			
			// if it's marked as RemindUntilComplete, this should be treated as Today's date			
		 	if ( reminder.remindUntilCompleted == REMINDERFOX_REMIND_UNTIL_COMPLETE_MARKED && j == startIndex ) {
		 		var todaysDate = new Date();
		 		if (  todaysDate.getFullYear() == year ) {   // only valid for current year in the calendar
			 		var ignore = false;
		 			var displayList = document.getElementById("displayType");	
					if ( displayList != null ) {	
						var displayListIndex = displayList.selectedIndex;
						// month or week
						if ( displayListIndex == 1 || displayListIndex == 2 ) {
							// if the date is outside of the selected month/week, then just show it.
							// Otherwise, go ahead and show it as Today's date.							
							if ( !( reminderFox_compareDates( todaysDate, dateSpan.start) > -1 &&
								reminderFox_compareDates( todaysDate, dateSpan.end) < 1 ) ) {
								ignore = true;
							}
						}
					}
					if ( !ignore ) {
		 				reminder = reminderFox_cloneReminderFoxEvent(reminder);		 	
						reminder.date  = new Date( todaysDate.getFullYear(), todaysDate.getMonth(), todaysDate.getDate(), 
						 			reminder.date.getHours(), reminder.date.getMinutes() );		
					}
		 		}
		 	}		 	
	
			monthArray = calendarReminderArray2[reminder.date.getMonth()];
			if ( monthArray == null ) {
				monthArray = new Array(31);
				calendarReminderArray2[reminder.date.getMonth()] = monthArray;
			}
				
			monthDay = reminder.date.getDate();
			dayReminderArray = monthArray[monthDay - 1];
			if ( dayReminderArray == null ) {
				dayReminderArray = new Array();
				monthArray[monthDay - 1] = dayReminderArray;
			}
			length = dayReminderArray.length;
			
			var ignoreReminder = false;
//			if (HIDE_COMPLETED_ITEMS &&
//				 reminderFox_isCompletedForDate( reminder, reminder.date) )  {
//				ignoreReminder = true;				
//			}
			if ( !ignoreReminder ) {
				dayReminderArray[length] = reminder;
			}
		}
	}
	
	return calendarReminderArray2;
}
 
 
 function redrawWeekNumbers(  ) {
 	var showWeekNum = reminderFox_getPreferenceValue( REMINDER_FOX_SHOW_WEEK_NUMS_PREF ); // Week Numbering:  0 (none), 1 (default), 2 (ISO 8601)
 	var weekGrid = document.getElementById( "oe-date-picker-month-week-grid");
 	if ( showWeekNum != null && showWeekNum == 1 || showWeekNum == 2 ) {
 		weekGrid.removeAttribute( "hidden" );
 		// get week number for first week displayed in the calendar
 		var startOfThisMonthDate = new Date(oeDatePicker.gSelectedDate.getFullYear(), oeDatePicker.gSelectedDate.getMonth(), 1);
		var dowOffset =  oeDatePicker.gStartingDayOfWeek;
		var newYear = new Date(startOfThisMonthDate.getFullYear(),0,1);
		var day = newYear.getDay() - dowOffset; //the day of week the year begins on
		day = (day >= 0 ? day : day + 7);
		var daynum = Math.floor((startOfThisMonthDate.getTime() - newYear.getTime() -
			(startOfThisMonthDate.getTimezoneOffset()-newYear.getTimezoneOffset())*60000)/86400000) + 1;
		var weeknum = Math.floor((daynum+day-1)/7); 
		var useISO = showWeekNum == 2; 
		if(!useISO || day < 4) {  // if using ISO standard, first week w/ day starting after Wed are 0-week; 
			weeknum = weeknum + 1; // otherwise, weeks start at 1
		}
		
	   // now fill in calendar box with week #s	
	   var endWeekIndex = 5;	
 	   for( var weekBoxIndex = 1; weekBoxIndex <= endWeekIndex; ++weekBoxIndex )  {
       		// get the day text box
      		var dayNumberItem = document.getElementById( "oe-date-picker-week-text-" + weekBoxIndex );
      		dayNumberItem.setAttribute( "value", weeknum );
      		weeknum++;
      		// reset to week 1 at the end of the year
      		if(weeknum > 52) {
				weeknum = weeknum - 52;  
			}
 	   }
 	   
 	   // handle last row (as it may be empty)
 	   	var lastWeekRow = document.getElementById( "oe-date-picker-month-day-text-36");
 	   	var val = weeknum;
	 	if ( lastWeekRow.getAttribute( "value" ) == "" ) { 
	 		val = ""; // don't fill in the last calendar row; no dates fall in it.
	 	}
	 	var dayNumberItem = document.getElementById( "oe-date-picker-week-text-6" );
      	dayNumberItem.setAttribute( "value", val );
 	}
 }


function reminderFox_addMultipleEndDates(reminder, currentDate, multipleDayEvents) {
	if ( reminder.durationTime != null ) {
		if ( reminder.allDayEvent ) {
			if (reminder.durationTime >86400000 ) {   // 24 * 60 * 60 * 1000 = 1 day in ms
				//var reminderInstanceDate = new Date(oeDatePicker.gSelectedDate.getFullYear(),oeDatePicker.gSelectedDate.getMonth(), dayNumber );
				var reminderInstanceDate =reminder.date;
				var reminderInstanceEndDate = new Date(reminderInstanceDate.getTime() + reminder.durationTime);		
				reminderInstanceEndDate.setDate( reminderInstanceEndDate.getDate() - 1); // -1 enddate offset
				
				if ( reminderFox_compareDates(reminderInstanceEndDate, currentDate ) != -1 ) {
					// set end date
					multipleDayEvents[multipleDayEvents.length] = reminder;
				}
			}
		}
		else {
			if ( reminder.durationTime > 60000 ) {
				var reminderInstanceDate =reminder.date;
				var reminderInstanceEndDate = new Date(reminderInstanceDate.getTime() + reminder.durationTime);	
				
				if (reminderInstanceEndDate.getMonth() == reminderInstanceDate.getMonth() &&
					reminderInstanceEndDate.getDate() == reminderInstanceDate.getDate() ) {
					// same days..  do nothing
				}
				// multiple days
				else { 
					// set end date
					if ( reminderFox_compareDates(reminderInstanceEndDate, currentDate ) != -1 ) {
						// set end date
						multipleDayEvents[multipleDayEvents.length] = reminder;
					}
				}
			}
		}
	}	
}


function reminderFox_calendarTooltip(event, tooltipIdNumber ) {
	 // clear old tooltip
   	 var tooltipItem = document.getElementById( "day-"+tooltipIdNumber  +"-tooltip");
     while (tooltipItem.hasChildNodes()) {
    	 tooltipItem.removeChild(tooltipItem.firstChild);
  	 }
  	 
   var monthArray = null;   
   var isReminder = true;
   var remindersTab = document.getElementById("remindersTab");
   var lastMonthArray = null;
   if ( remindersTab != null  ) {   // ignore this if we are doing a popup from within the Event dialog
		if ( isReminderTabSelected() ) {		
		   if ( calendarReminderArray == null ) {	
		   		createCalendarReminderArray();	   	
		   	}
		   	monthArray = calendarReminderArray[oeDatePicker.gSelectedDate.getMonth()];
		   	
		    if ( oeDatePicker.gSelectedDate.getMonth() > 0 ) {
		   	 	lastMonthArray = calendarReminderArray[oeDatePicker.gSelectedDate.getMonth()-1];
		   	 }
		}
		else {
			isReminder = false;
		   	if ( calendarTodoArray == null ) {
		   		createCalendarTodoArray();
		   	}
		   	 monthArray = calendarTodoArray[oeDatePicker.gSelectedDate.getMonth()];
		   	 if ( oeDatePicker.gSelectedDate.getMonth() > 0 ) {
		   	 	lastMonthArray = calendarTodoArray[oeDatePicker.gSelectedDate.getMonth()-1];
		   	 }
		}
   }
   else { 
     if ( oeDatePicker.launchAdd ) {
	   var calendarReminderArray2 = null;
	   if ( calendarReminderArray2 == null ) {	   		
	  	 	calendarReminderArray2 = createCalendarReminderArray2();	   				   		
	   	}
	   	monthArray = calendarReminderArray2[oeDatePicker.gSelectedDate.getMonth()];
	   	if ( oeDatePicker.gSelectedDate.getMonth() > 0 ) {
	   		lastMonthArray = calendarReminderArray2[oeDatePicker.gSelectedDate.getMonth()-1];
	   	}
	  }
   }
   
   // check last month for any reminders with end dates carrying over to this month
    var currentSelectedDate = new Date(oeDatePicker.gSelectedDate.getFullYear(), oeDatePicker.gSelectedDate.getMonth(), tooltipIdNumber);
	var multipleDayEvents = new Array();
	// for performance; we just check last 10 days of the previous month
	 if ( lastMonthArray != null && lastMonthArray.length > 0) {
	 	for ( var i = lastMonthArray.length-10; i < lastMonthArray.length; i++ ) {
	 		var reminderDaysArray = lastMonthArray[i];
	 		if ( reminderDaysArray != null ) { 
   		 		for ( var j = 0; j < reminderDaysArray.length; j++ ) {
   		 			var reminder = reminderDaysArray[j];
   		 			reminderFox_addMultipleEndDates( reminder, currentSelectedDate, multipleDayEvents );
   		 		}	
	 		}
	 	}
	 }

	 if ( monthArray != null ) {
	   // check previous month days prior to today with end dates carrying over to today or beyond...
	   for ( var i = 0; i < (tooltipIdNumber-1); i++ ) { 
	 		var reminderDaysArray = monthArray[i];
	 		if ( reminderDaysArray != null ) { 
		 		for ( var j = 0; j < reminderDaysArray.length; j++ ) {
		 			var reminder = reminderDaysArray[j];
		 			reminderFox_addMultipleEndDates( reminder, currentSelectedDate, multipleDayEvents );	
		 		}	
	 		}
	 	}
	 	
	 	
     	var reminderDaysArray = monthArray[tooltipIdNumber-1];
  	 	if ( reminderDaysArray != null ) {
			var multipleEventsOnThisDate = (reminderDaysArray.length + multipleDayEvents.length) > 1 ;
     	   	for ( var  i = 0; i < reminderDaysArray.length; i++ ) {
     	   		var drawSeparator = i > 0;
				reminderFox_addCalendarReminderToTooltip(tooltipItem, reminderDaysArray[i], multipleEventsOnThisDate, drawSeparator);
	        }
  	 	}
	 }
	 
	 if ( multipleDayEvents != null ) {    
	 	var reminderDaysArrayLen = 0;
	 	if (  reminderDaysArray != null ) {
	 		 reminderDaysArrayLen = reminderDaysArray.length;
	 	}
        for ( var  i = 0; i < multipleDayEvents.length; i++ ) {
 	   		var drawSeparator = reminderDaysArrayLen > 0 || i > 0;
			reminderFox_addCalendarReminderToTooltip(tooltipItem, multipleDayEvents[i], multipleEventsOnThisDate, drawSeparator);
        }
 	}
	
   return true;
}

function reminderFox_addCalendarReminderToTooltip(tooltipItem, reminder, multipleEventsOnThisDate, drawSeparator ) {
   	if ( drawSeparator ) {
		var hbox = document.createElement("hbox");		
		hbox.setAttribute( "class", "reminderFox-footer3");
		hbox.setAttribute( "align", "center");
		tooltipItem.appendChild(hbox);	
		
		hbox = document.createElement("hbox");		
		hbox.setAttribute( "class", "reminderFox-footer2");
		hbox.setAttribute( "align", "center");
		tooltipItem.appendChild(hbox);	
	}
	var important = false;
	if ( reminder.priority == REMINDER_PRIORITY_IMPORTANT ) {
		important = true;
	}
	
	// see if current instance of reminder is completed
	var completed = false;	
	if  ( reminderFox_isCompletedForDate( reminder, reminder.date )  ) {
		completed = true;
	}  
	
	addTooltipWithLabel( tooltipItem, null, reminder.summary, important, completed, reminderFox_getBundle().getString("rf.html.heading.description")  ); 
	
	if ( reminder.date != null ) { 
		var dateString = reminderFox_getDateVariableString( reminder, reminder.date);
		var timeCellLabel = reminderFox_mail_getTimeString(reminder.date);
		if ( !reminder.allDayEvent ) {
			dateString = dateString + ", " + timeCellLabel;
		}
		
		if ( reminder.durationTime != null ) {
			var reminderInstanceEndDate = new Date(parseInt(reminder.date.getTime()) + reminder.durationTime);		
			if ( reminder.allDayEvent ) {
				if (reminder.durationTime >86400000 ) {   // 24 * 60 * 60 * 1000 = 1 day in ms
					reminderInstanceEndDate.setDate( reminderInstanceEndDate.getDate() - 1); // -1 enddate offset
					var endDateStr = reminderFox_getDateVariableString( reminder, reminderInstanceEndDate);
					dateString += " - " +  endDateStr;
				}
			}
			else {
				var endTime = reminderFox_mail_getTimeString(reminderInstanceEndDate);
				if (reminderInstanceEndDate.getMonth() == reminder.date.getMonth() &&
					reminderInstanceEndDate.getDate() == reminder.date.getDate() ) {
					// same days.. 
					dateString += " - " +  endTime;
				}
				// multiple days
				else { 
					var endDateStr = reminderFox_getDateVariableString( reminder, reminderInstanceEndDate);
					dateString += " - " +  endDateStr + ", " + endTime;
				}
			}
		}
		addTooltipWithLabel( tooltipItem,null, dateString, false, false, reminderFox_getBundle().getString("rf.html.heading.date") );
	}
	
	if ( reminder.categories != null && reminder.categories != "" ) {			
		addTooltipWithLabel( tooltipItem, null, reminder.categories, false, false, reminderFox_getBundle().getString("rf.add.reminders.tooltip.categories")); 		
	}
	
	if ( reminder.completedDate != null ) {
		var completedDate = reminderFox_getDateVariableString( reminder, reminder.completedDate );
		addTooltipWithLabel( tooltipItem, null, completedDate, false, false, reminderFox_getBundle().getString("rf.add.reminders.tooltip.dateCompleted") );
		
	}
	if ( reminder.location != null && reminder.location != "" ) {			
		addTooltipWithLabel( tooltipItem, null, reminder.location, false, false, reminderFox_getBundle().getString("rf.add.reminders.tooltip.locaton") );  
	}
	
	if ( reminder.url != null && reminder.url != "" ) {			
		addTooltipWithLabel( tooltipItem, null, reminder.url, false, false, reminderFox_getBundle().getString("rf.add.reminders.tooltip.url") );
	}				
			
	// add notes to to tooltip (if applicable)		
 	if ( reminder.notes != null ) {
 		if ( multipleEventsOnThisDate ) { 
  	 		addNotesToTooltip( reminder.notes, tooltipItem, 10 );  // limit to 6 lines of notes
 		}
 		else {
 			addNotesToTooltip( reminder.notes, tooltipItem );
 		}
   }		
}


function addTooltipWithLabel( tooltipItem, columnId, value, importantStatus, completedStatus, labelText) {
	var hbox = document.createElement("hbox");		
	var columnLabel;	
	if ( columnId == null ) {
		columnLabel = labelText;
	}
	else {
		columnLabel = getLabelForColumn(columnId);		
	}
	
	var title = document.createElement("description");
	title.setAttribute("value",columnLabel + ": ");
	title.setAttribute( "style", "font-weight:bold");
	hbox.appendChild( title );
	
	var tooltipValue = document.createElement("description");
	tooltipValue.setAttribute("value", value );
	
	if ( importantStatus && completedStatus ) {
		tooltipValue.setAttribute( "style", " text-decoration: line-through; color: red" );
	}
	else if ( importantStatus ) {
		tooltipValue.setAttribute( "style", "color: red" );
	}
	else if ( completedStatus ) {
		tooltipValue.setAttribute( "style", " text-decoration: line-through" );
	}
	
	hbox.appendChild( tooltipValue );
	
	tooltipItem.appendChild(hbox);		
}


function reminderFox_getDateVariableString(reminder, date )  {
	var dateVariableString = null;
	try {
		dateVariableString = reminderFox_getUnicodePref(REMINDER_FOX_PREF + "." + REMINDER_FOX_LIST_DATE_LABEL);
		if ( dateVariableString != REMINDER_FOX_LIST_DATE_LABEL_DEFAULT) {
			useDefaultDate = false;
		}
	} catch(e) {
		 dateVariableString = REMINDER_FOX_LIST_DATE_LABEL_DEFAULT;
	}
	return reminderFox_getDateVariable( reminder, date, dateVariableString );
}


